'use strict';

function GroupResetModalCtrl($scope, $rootScope, $timeout, AppConfig, $http, GroupsManager, GroupsRoundsManager, GroupResults){

    $scope.$on('Groups:openResetGroupModal', function(event, group){
        $scope.openModal();
        $scope.group = group;
    });


    $scope.openModal = function(){
        angular.element('#modal-group-reset').modal('show');
    }

    $scope.closeModal = function(){
        angular.element('#modal-group-reset').modal('hide');
    }


    $scope.resetGroup = function(){
        var message = {
            title: 'Resetowanie grupy'
            ,msg: 'Trwa resetowanie grupy'
        }

        $scope.closeModal();

        $rootScope.$broadcast('Message:addMsg', message);

        $http.post(AppConfig.urlGroupReset, $scope.group)
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                $scope.closeModal();

                if(typeof data.error != 'undefined')
                {
                    $rootScope.$broadcast('Message:error', data.error);
                }
                else
                {
                    var successMessage = {
                        title: 'Resetowanie grupy'
                        ,msg: 'Poprawnie zresetowano grupę ' + $scope.group.name
                    };
                    $timeout(function(){
                        $rootScope.$broadcast('Message:addMsg', successMessage);
                    }, 500);

                    $timeout(function(){
                        $rootScope.$broadcast('Message:delMsg', successMessage);
                    }, 3500);

                    GroupsManager.setGroup(data);
                    GroupsRoundsManager.clearAll()
                    GroupsRoundsManager.loadGroups();
                    GroupResults.clearAll();
                }
            })
            .error(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                $rootScope.$broadcast('Message:error', data);
            })
        ;
    }
}

GroupResetModalCtrl.$inject = ['$scope', '$rootScope', '$timeout', 'AppConfig', '$http', 'GroupsManager', 'GroupsRoundsManager', 'GroupResults'];